using NUnit.Framework;
using PDFCNUnit.Inet.Pdfc;
using System.Diagnostics;

namespace Samples
{
    /// <summary>
    /// This is a non functional sample showcasing the usage of i-net PDFC NUnit.
    /// To run this test you must replace the placeholders with proper values fitting your running i-net PDFC server.
    /// </summary>
    public class PDFCNUnitUsage
    {
        /// <summary>
        /// Sets the properties for the i-net PDFC server, the nunit test should be executed for.
        /// </summary>
        [OneTimeSetUp]
        public void Init()
        {
            // the URL to the i-net PDFC server
            PdfcAssert.SetServicePath("<url to the server like 'http://localhost:9900'>");
            
            // the user to login to the server
            PdfcAssert.SetCredentials("<user>", "<password>");

            // specify the PDFC profile to be used
            PdfcAssert.SetPdfcConfiguration("Text only");

            // the default log level is SourceLevels.Warning
            // if you search for problems then you can enable the logging
            PdfcAssert.SetLogLevel(SourceLevels.Verbose);
        }

        [SetUp]
        public void Setup()
        {
        }

        /// <summary>
        /// Compares the two documents and checks that both have no differences
        /// </summary>
        [Test]
        public void CompareEquals()
        {
            PdfcAssert.AssertPdfEquals(@"<string path to the first document to compare>", @"<string path to the second document to compare>");
        }

        /// <summary>
        /// Compares the two documents and checks that there are differences
        /// </summary>
        [Test]
        public void CompareNotEquals()
        {
            PdfcAssert.AssertPdfNotEquals(@"<string path to the first document to compare>", @"<string path to the second document to compare>");
        }
    }
}